<?php
class UserLanguage {
    // Database connection
    private $conn;
    private $table = "user_language";


    // Properties
    public $user_location_id;
    public $user_id;
    public $language_id;
    
    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all
    public function read() {
        $query = "SELECT
            user_location_id,
            user_id,
            language_id
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            user_location_id,
            user_id,
            language_id
        FROM 
            " . $this->table . "
        WHERE
            user_location_id = :user_location_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":user_location_id", $this->user_location_id);
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->language_id = $row["language_id"]; 
        $this->user_id = $row["user_id"]; 
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            language_id = :language_id,
            user_id = :user_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->language_id = htmlspecialchars(strip_tags($this->language_id));
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));

        // Bind data
        $stmt->bindParam(":language_id", $this->language_id);
        $stmt->bindParam(":user_id", $this->user_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            language_id = :language_id,
            user_id = :user_id
        WHERE
            user_location_id = :user_location_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->language_id = htmlspecialchars(strip_tags($this->language_id));
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $this->user_location_id = htmlspecialchars(strip_tags($this->user_location_id));

        // Bind data
        $stmt->bindParam(":language_id", $this->language_id);
        $stmt->bindParam(":user_id", $this->user_id);
        $stmt->bindParam(":user_location_id", $this->user_location_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }

    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE user_location_id = :user_location_id";
        $stmt = $this->conn->prepare($query);

        $this->user_location_id = htmlspecialchars(strip_tags($this->user_location_id));
        $stmt->bindParam(":user_location_id", $this->user_location_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}