<?php
class UserDriversLicence {
    // Database connection
    private $conn;
    private $table = "user_drivers_licence";


    // Properties
    public $us_drivers_licence_id;
    public $user_id;
    public $drivers_licence_id;
    
    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all
    public function read() {
        $query = "SELECT
            us_drivers_licence_id,
            user_id,
            drivers_licence_id
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            us_drivers_licence_id,
            user_id,
            drivers_licence_id
        FROM 
            " . $this->table . "
        WHERE
            us_drivers_licence_id = :us_drivers_licence_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":us_drivers_licence_id", $this->us_drivers_licence_id);
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->user_id = $row["user_id"]; 
        $this->drivers_licence_id = $row["drivers_licence_id"]; 
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            drivers_licence_id = :drivers_licence_id,
            user_id = :user_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->drivers_licence_id = htmlspecialchars(strip_tags($this->drivers_licence_id));
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));

        // Bind data
        $stmt->bindParam(":drivers_licence_id", $this->drivers_licence_id);
        $stmt->bindParam(":user_id", $this->user_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            drivers_licence_id = :drivers_licence_id,
            user_id = :user_id
        WHERE
            us_drivers_licence_id = :us_drivers_licence_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->drivers_licence_id = htmlspecialchars(strip_tags($this->drivers_licence_id));
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $this->us_drivers_licence_id = htmlspecialchars(strip_tags($this->us_drivers_licence_id));

        // Bind data
        $stmt->bindParam(":drivers_licence_id", $this->drivers_licence_id);
        $stmt->bindParam(":user_id", $this->user_id);
        $stmt->bindParam(":us_drivers_licence_id", $this->us_drivers_licence_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }

    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE us_drivers_licence_id = :us_drivers_licence_id";
        $stmt = $this->conn->prepare($query);

        $this->us_drivers_licence_id = htmlspecialchars(strip_tags($this->us_drivers_licence_id));
        $stmt->bindParam(":us_drivers_licence_id", $this->us_drivers_licence_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}