<?php
class UserCompany {
    // Database connection
    private $conn;
    private $table = "user_company";
    
    // Properties
    public $user_company_id;
    public $user_id;
    public $company_id;
    public $entry_key;
    public $active;
    
    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Read all users in company
    public function readByCompanyId($company_id) {
        $query = "SELECT
            companies.company_id,
            companies.company_name,
            users.user_fname,
            users.user_lname,
            users.user_email,
            user_company.entry_key
        FROM 
            (" . $this->table . "
            INNER JOIN companies ON user_company.company_id = companies.company_id)
            INNER JOIN users ON user_company.user_id = users.user_id
        WHERE 
            companies.company_id = :company_id OR companies.parent_id = :company_id";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":company_id", $company_id);
        $stmt->execute();
        return $stmt;
    }

    // Get all
    public function read() {
        $query = "SELECT
            user_company_id,
            user_id,
            company_id,
            entry_key,
            active
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            user_company_id,
            user_id,
            company_id,
            entry_key,
            active
        FROM 
            " . $this->table . "
        WHERE
            user_company_id = :user_company_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":user_company_id", $this->user_company_id);
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->user_id = $row["user_id"]; 
        $this->company_id = $row["company_id"];
        $this->entry_key = $row["entry_key"];  
        $this->active = $row["active"];  
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            company_id = :company_id,
            user_id = :user_id,
            entry_key = :entry_key
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $this->entry_key = htmlspecialchars(strip_tags($this->entry_key));
        // Bind data
        $stmt->bindParam(":company_id", $this->company_id);
        $stmt->bindParam(":user_id", $this->user_id);
        $stmt->bindParam(":entry_key", $this->entry_key);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            company_id = :company_id,
            user_id = :user_id,
            entry_key = :entry_key,
            active = :active
        WHERE
            user_company_id = :user_company_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $this->entry_key = htmlspecialchars(strip_tags($this->entry_key));
        $this->active = htmlspecialchars(strip_tags($this->active));
        $this->user_company_id = htmlspecialchars(strip_tags($this->user_company_id));
        

        // Bind data
        $stmt->bindParam(":company_id", $this->company_id);
        $stmt->bindParam(":user_id", $this->user_id);
        $stmt->bindParam(":entry_key", $this->entry_key);
        $stmt->bindParam(":active", $this->active);
        $stmt->bindParam(":user_company_id", $this->user_company_id);
        
        

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }

    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE user_company_id = :user_company_id";
        $stmt = $this->conn->prepare($query);

        $this->user_company_id = htmlspecialchars(strip_tags($this->user_company_id));
        $stmt->bindParam(":user_company_id", $this->user_company_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}