<?php
class Room
{
    // Database connection
    private $conn;
    private $table = "rooms";

    // Properties
    public $room_id;
    public $room_name;
    public $room_profile1;
    public $room_profile2;

    // Constructor
    public function __construct($db)
    {
        $this->conn = $db;
    }

    // Get all profiles by user id
    public function read($profile_id) {
        $query = "SELECT
            room_id,
            room_name,
            room_profile1,
            room_profile2
            
        FROM 
            " . $this->table . "
        WHERE 
            room_profile1 = :profile_id OR room_profile2 = :profile_id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":profile_id", $profile_id); // Bind 1st ? to address_book_id
        $stmt->execute();
        return $stmt;
    }

   
}
