<?php
class Qualification {
    // Database connection
    private $conn;
    private $table = "qualifications";

    // Properties
    public $qualification_id;
    public $qual_name;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all areas
    public function read() {
        $query = "SELECT
            qualification_id,
            qual_name
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get area by id
    public function read_single() {
        $query = "SELECT
            qualification_id,
            qual_name
        FROM 
            " . $this->table . "
        WHERE
            qualification_id = :qualification_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":qualification_id", $this->qualification_id); // Bind 1st ? to qualification_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->qualification_id = $row["qualification_id"]; 
        $this->qual_name = $row["qual_name"]; 
    }
    
    // Create a area
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            qual_name = :qual_name
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->qual_name = htmlspecialchars(strip_tags($this->qual_name));

        // Bind data
        $stmt->bindParam(":qual_name", $this->qual_name);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            qual_name = :qual_name
        WHERE
            qualification_id = :qualification_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->qual_name = htmlspecialchars(strip_tags($this->qual_name));
        $this->qualification_id = htmlspecialchars(strip_tags($this->qualification_id));

        // Bind data
        $stmt->bindParam(":qual_name", $this->qual_name);
        $stmt->bindParam(":qualification_id", $this->qualification_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE qualification_id = :qualification_id";
        $stmt = $this->conn->prepare($query);

        $this->qualification_id = htmlspecialchars(strip_tags($this->qualification_id));
        $stmt->bindParam(":qualification_id", $this->qualification_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}