<?php
class ProviderLicence {
    // Database connection
    private $conn;
    private $table = "provider_licences";

    // Properties
    public $pl_id;
    public $pl_number;
    public $pl_date;
    public $provider_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all
    public function read() {
        $query = "SELECT
            pl_id,
            pl_number,
            pl_date,
            provider_id
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function readByProviderID($provider_id) {
        $query = "SELECT
            pl_id,
            pl_number,
            pl_date,
            provider_id
        FROM 
            " . $this->table . "
        WHERE
        provider_id = :provider_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":provider_id", $provider_id); 
        $stmt->execute();
        return $stmt;
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
        pl_number = :pl_number,
        pl_date = :pl_date,
        provider_id = :provider_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->pl_number = htmlspecialchars(strip_tags($this->pl_number));
        $this->pl_date = htmlspecialchars(strip_tags($this->pl_date));
        $this->provider_id = htmlspecialchars(strip_tags($this->provider_id));

        // Bind data
        $stmt->bindParam(":pl_number", $this->pl_number);
        $stmt->bindParam(":pl_date", $this->pl_date);
        $stmt->bindParam(":provider_id", $this->provider_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update comment
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            pl_number = :pl_number,
            pl_date = :pl_date,
            provider_id = :provider_id
        WHERE
            pl_id = :pl_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->pl_number = htmlspecialchars(strip_tags($this->pl_number));
        $this->pl_date = htmlspecialchars(strip_tags($this->pl_date));
        $this->provider_id = htmlspecialchars(strip_tags($this->provider_id));
        $this->pl_id = htmlspecialchars(strip_tags($this->pl_id));

        // Bind data
        $stmt->bindParam(":pl_number", $this->pl_number);
        $stmt->bindParam(":pl_date", $this->pl_date);
        $stmt->bindParam(":provider_id", $this->provider_id);
        $stmt->bindParam(":pl_id", $this->pl_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete comment
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE pl_id = :pl_id";
        $stmt = $this->conn->prepare($query);

        $this->pl_id = htmlspecialchars(strip_tags($this->pl_id));
        $stmt->bindParam(":pl_id", $this->pl_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}