<?php
class ProviderCategory {
    // Database connection
    private $conn;
    private $table = "provider_categories";

    // Properties
    public $pc_id;
    public $pc_name;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all areas
    public function read() {
        $query = "SELECT
            pc_id,
            pc_name
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get area by id
    public function read_single() {
        $query = "SELECT
            pc_id,
            pc_name
        FROM 
            " . $this->table . "
        WHERE
            pc_id = :pc_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":pc_id", $this->pc_id); // Bind 1st ? to pc_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->pc_id = $row["pc_id"]; 
        $this->pc_name = $row["pc_name"]; 
    }
    
    // Create a area
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            pc_name = :pc_name
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->pc_name = htmlspecialchars(strip_tags($this->pc_name));

        // Bind data
        $stmt->bindParam(":pc_name", $this->pc_name);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update user
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            pc_name = :pc_name
        WHERE
            pc_id = :pc_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->pc_name = htmlspecialchars(strip_tags($this->pc_name));
        $this->pc_id = htmlspecialchars(strip_tags($this->pc_id));

        // Bind data
        $stmt->bindParam(":pc_name", $this->pc_name);
        $stmt->bindParam(":pc_id", $this->pc_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete a user
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE pc_id = :pc_id";
        $stmt = $this->conn->prepare($query);

        $this->pc_id = htmlspecialchars(strip_tags($this->pc_id));
        $stmt->bindParam(":pc_id", $this->pc_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}