<?php
class Profession {
    // Database connection
    private $conn;
    private $table = "professions";

    // Properties
    public $profession_id;
    public $prof_name;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all areas
    public function read() {
        $query = "SELECT
            profession_id,
            prof_name
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get area by id
    public function read_single() {
        $query = "SELECT
            profession_id,
            prof_name
        FROM 
            " . $this->table . "
        WHERE
            profession_id = :profession_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":profession_id", $this->profession_id); // Bind 1st ? to profession_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->profession_id = $row["profession_id"]; 
        $this->prof_name = $row["prof_name"]; 
    }
    
    // Create a area
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            prof_name = :prof_name
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->prof_name = htmlspecialchars(strip_tags($this->prof_name));

        // Bind data
        $stmt->bindParam(":prof_name", $this->prof_name);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            prof_name = :prof_name
        WHERE
            profession_id = :profession_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->prof_name = htmlspecialchars(strip_tags($this->prof_name));
        $this->profession_id = htmlspecialchars(strip_tags($this->profession_id));

        // Bind data
        $stmt->bindParam(":prof_name", $this->prof_name);
        $stmt->bindParam(":profession_id", $this->profession_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE profession_id = :profession_id";
        $stmt = $this->conn->prepare($query);

        $this->profession_id = htmlspecialchars(strip_tags($this->profession_id));
        $stmt->bindParam(":profession_id", $this->profession_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}