<?php
class Presentation {
    // Database connection
    private $conn;
    private $table = "presentation";

    // Properties
    public $presentation_id;
    public $pres_file_path;
    public $company_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all ab
    public function read() {
        $query = "SELECT
            presentation_id,
            pres_file_path,
            company_id
            
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get ab by id
    public function read_single() {
        $query = "SELECT
            presentation_id,
            pres_file_path,
            company_id
            
        FROM 
            " . $this->table . "
        WHERE
            presentation_id = :presentation_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":presentation_id", $this->presentation_id); // Bind 1st ? to presentation_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->pres_file_path = $row["pres_file_path"]; 
        $this->company_id = $row["company_id"]; 
    }
    
    // Create ab
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            pres_file_path = :pres_file_path,
            company_id = :company_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->pres_file_path = htmlspecialchars(strip_tags($this->pres_file_path));
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));

        // Bind data
        $stmt->bindParam(":pres_file_path", $this->pres_file_path);
        $stmt->bindParam(":company_id", $this->company_id);
        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update ab
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            pres_file_path = :pres_file_path,
            company_id = :company_id
        WHERE
            presentation_id = :presentation_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->pres_file_path = htmlspecialchars(strip_tags($this->pres_file_path));
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));
        $this->presentation_id = htmlspecialchars(strip_tags($this->presentation_id));

        // Bind data
        $stmt->bindParam(":pres_file_path", $this->pres_file_path);
        $stmt->bindParam(":company_id", $this->company_id);
        $stmt->bindParam(":presentation_id", $this->presentation_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete ab
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE presentation_id = :presentation_id";
        $stmt = $this->conn->prepare($query);

        $this->presentation_id = htmlspecialchars(strip_tags($this->presentation_id));
        $stmt->bindParam(":presentation_id", $this->presentation_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}