<?php
class Phonebook {
    // Database connection
    private $conn;
    private $table = "phonebook";

    // Properties
    public $phonebook_id;
    public $pb_name;
    public $pb_number;
    public $user_id;
    public $company_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get by company_id
    public function read($company_id) {
        $query = "SELECT
            phonebook_id,
            pb_name,
            pb_number
            FROM 
            " . $this->table . "
        WHERE 
            company_id = :company_id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":company_id", $company_id);
        $stmt->execute();
        return $stmt;
    }

    //Get by admin_id
    public function readByAdminId($admin_id) {
        $query = "SELECT DISTINCT
            phonebook_id,
            pb_name,
            pb_number
        FROM 
            " . $this->table . 
            " INNER JOIN ((users INNER JOIN (
                user_company 
                INNER JOIN companies ON 
                user_company.company_id = companies.company_id) ON 
                users.user_id = user_company.user_id)
                INNER JOIN admins ON users.user_id = admins.user_id) ON phonebook.user_id = users.user_id
        WHERE 
            admins.admin_id = :admin_id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":admin_id", $admin_id); 
        $stmt->execute();
        return $stmt;
    }
    
    // Get pb by id
    public function read_single() {
        $query = "SELECT
            phonebook_id,
            pb_name,
            pb_number,
            user_id
        FROM 
            " . $this->table . "
        WHERE
            phonebook_id = :phonebook_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":phonebook_id", $this->phonebook_id); // Bind 1st ? to phonebook_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->pb_name = $row["pb_name"]; 
        $this->pb_number = $row["pb_number"]; 
        $this->user_id = $row["user_id"]; 
    }
    
    // Create pb
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            pb_name = :pb_name,
            pb_number = :pb_number,
            company_id = :company_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->pb_name = htmlspecialchars(strip_tags($this->pb_name));
        $this->pb_number = htmlspecialchars(strip_tags($this->pb_number));
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));

        // Bind data
        $stmt->bindParam(":pb_name", $this->pb_name);
        $stmt->bindParam(":pb_number", $this->pb_number);
        $stmt->bindParam(":company_id", $this->company_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update pb
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            pb_name = :pb_name,
            pb_number = :pb_number,
            user_id = :user_id
        WHERE
            phonebook_id = :phonebook_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->pb_name = htmlspecialchars(strip_tags($this->pb_name));
        $this->pb_number = htmlspecialchars(strip_tags($this->pb_number));
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $this->phonebook_id = htmlspecialchars(strip_tags($this->phonebook_id));

        // Bind data
        $stmt->bindParam(":pb_name", $this->pb_name);
        $stmt->bindParam(":pb_number", $this->pb_number);
        $stmt->bindParam(":user_id", $this->user_id);
        $stmt->bindParam(":phonebook_id", $this->phonebook_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete pb
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE phonebook_id = :phonebook_id";
        $stmt = $this->conn->prepare($query);

        $this->phonebook_id = htmlspecialchars(strip_tags($this->phonebook_id));
        $stmt->bindParam(":phonebook_id", $this->phonebook_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}