<?php
class Location {
    // Database connection
    private $conn;
    private $table = "locations";
    // location_id`, `location_name`, `company_id

    // Properties
    public $location_id;
    public $location_name;
    public $company_id;
    public $active;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all 
    public function read() {
        $query = "SELECT
            location_id,
            location_name,
            company_id,
            active
        FROM 
            " . $this->table . "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function readLocationByCompanyId(){
        $query = "SELECT
            location_name,
            company_id,
            active
        FROM 
            " . $this->table . "
        WHERE
        company_id = :company_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":company_id", $this->company_id); 
        $stmt->execute();
    
        // Fetch all rows as assoc_array
        $location_names = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        return $location_names;
    }    
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            location_id,
            location_name,
            company_id,
            active
        FROM 
            " . $this->table . "
        WHERE
            location_id = :location_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":location_id", $this->location_id); 
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->location_id = $row["location_id"]; 
        $this->location_name = $row["location_name"]; 
        $this->company_id = $row["company_id"]; 
        $this->active = $row["active"]; 
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            location_name = :location_name,
            company_id = :company_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->location_name = htmlspecialchars(strip_tags($this->location_name));
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));

        // Bind data
        $stmt->bindParam(":location_name", $this->location_name);
        $stmt->bindParam(":company_id", $this->company_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            location_name = :location_name,
            company_id = :company_id,
            active = :active
        WHERE
            location_id = :location_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->location_name = htmlspecialchars(strip_tags($this->location_name));
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));
        $this->active = htmlspecialchars(strip_tags($this->active));
        $this->location_id = htmlspecialchars(strip_tags($this->location_id));

        // Bind data
        $stmt->bindParam(":location_name", $this->location_name);
        $stmt->bindParam(":company_id", $this->company_id);
        $stmt->bindParam(":active", $this->active);
        $stmt->bindParam(":location_id", $this->location_id);


        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE location_id = :location_id";
        $stmt = $this->conn->prepare($query);

        $this->location_id = htmlspecialchars(strip_tags($this->location_id));
        $stmt->bindParam(":location_id", $this->location_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}