<?php
class Item {
    // Database connection
    private $conn;
    private $table = "items";

    // Properties
    public $item_id;
    public $item_title;
    public $item_desc;
    public $item_mere;
    public $item_time;
    public $item_visibility;
    public $item_user;
    public $item_image;
    public $item_image1;
    public $item_image2;
    public $item_image3;
    public $image_desc;
    public $image_desc1;
    public $image_desc2;
    public $image_desc3;
    public $category_id;
    public $report_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all 
    public function read() {
        $query = "SELECT
            item_id,
            item_title,
            item_desc,
            item_mere,
            item_time,
            item_visibility,
            item_user,
            item_image,
            item_image1,
            item_image2,
            item_image3,
            image_desc,
            image_desc1,
            image_desc2,
            image_desc3,
            category_id,
            report_id

        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            item_id,
            item_title,
            item_desc,
            item_mere,
            item_time,
            item_visibility,
            item_user,
            item_image,
            item_image1,
            item_image2,
            item_image3,
            image_desc,
            image_desc1,
            image_desc2,
            image_desc3,
            category_id,
            report_id
        FROM 
            " . $this->table . "
        WHERE
            item_id = :item_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":item_id", $this->item_id); // Bind 1st ? to item_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->item_id = $row["item_id"]; 
        $this->item_title = $row["item_title"]; 
        $this->item_desc = $row["item_desc"]; 
        $this->item_mere = $row["item_mere"]; 
        $this->item_time = $row["item_time"]; 
        $this->item_visibility = $row["item_visibility"]; 
        $this->item_user = $row["item_user"]; 
        $this->item_image = $row["item_image"]; 
        $this->item_image1 = $row["item_image1"];
        $this->item_image2 = $row["item_image2"]; 
        $this->item_image3 = $row["item_image3"]; 
        $this->image_desc = $row["image_desc"]; 
        $this->image_desc1 = $row["image_desc1"]; 
        $this->image_desc2 = $row["image_desc2"];
        $this->image_desc3 = $row["image_desc3"]; 
        $this->category_id = $row["category_id"]; 
        $this->report_id = $row["report_id"]; 
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            item_title = :item_title,
            item_desc = :item_desc,
            item_mere = :item_mere,
            item_time = :item_time,
            item_visibility = :item_visibility,
            item_user = :item_user,
            item_image = :item_image,
            item_image1 = :item_image1,
            item_image2 = :item_image2,
            item_image3 = :item_image3,
            image_desc = :image_desc,
            image_desc1 = :image_desc1,
            image_desc2 = :image_desc2,
            image_desc3 = :image_desc3,
            category_id = :category_id,
            report_id = :report_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->item_title = htmlspecialchars(strip_tags($this->item_title));
        $this->item_desc = htmlspecialchars(strip_tags($this->item_desc));
        $this->item_mere = htmlspecialchars(strip_tags($this->item_mere));
        $this->item_time = htmlspecialchars(strip_tags($this->item_time));
        $this->item_visibility = htmlspecialchars(strip_tags($this->item_visibility));
        $this->item_user = htmlspecialchars(strip_tags($this->item_user));
        $this->item_image = htmlspecialchars(strip_tags($this->item_image));
        $this->item_image1 = htmlspecialchars(strip_tags($this->item_image1));
        $this->item_image2 = htmlspecialchars(strip_tags($this->item_image2));
        $this->item_image3 = htmlspecialchars(strip_tags($this->item_image3));
        $this->image_desc = htmlspecialchars(strip_tags($this->image_desc));
        $this->image_desc1 = htmlspecialchars(strip_tags($this->image_desc1));
        $this->image_desc2 = htmlspecialchars(strip_tags($this->image_desc2));
        $this->image_desc3 = htmlspecialchars(strip_tags($this->image_desc3));
        $this->category_id = htmlspecialchars(strip_tags($this->category_id));
        $this->report_id = htmlspecialchars(strip_tags($this->report_id));

        // Bind data
        $stmt->bindParam(":item_title", $this->item_title);
        $stmt->bindParam(":item_desc", $this->item_desc);
        $stmt->bindParam(":item_mere", $this->item_mere);
        $stmt->bindParam(":item_time", $this->item_time);
        $stmt->bindParam(":item_visibility", $this->item_visibility);
        $stmt->bindParam(":item_user", $this->item_user);
        $stmt->bindParam(":item_image", $this->item_image);
        $stmt->bindParam(":item_image1", $this->item_image1);
        $stmt->bindParam(":item_image2", $this->item_image2);
        $stmt->bindParam(":item_image3", $this->item_image3);
        $stmt->bindParam(":image_desc", $this->image_desc);
        $stmt->bindParam(":image_desc1", $this->image_desc1);
        $stmt->bindParam(":image_desc2", $this->image_desc2);
        $stmt->bindParam(":image_desc3", $this->image_desc3);
        $stmt->bindParam(":category_id", $this->category_id);
        $stmt->bindParam(":report_id", $this->report_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            item_title = :item_title,
            item_desc = :item_desc,
            item_mere = :item_mere,
            item_time = :item_time,
            item_visibility = :item_visibility,
            item_user = :item_user,
            item_image = :item_image,
            item_image1 = :item_image1,
            item_image2 = :item_image2,
            item_image3 = :item_image3,
            image_desc = :image_desc,
            image_desc1 = :image_desc1,
            image_desc2 = :image_desc2,
            image_desc3 = :image_desc3,
            category_id = :category_id,
            report_id = :report_id
        WHERE
            item_id = :item_id
        ";

        $stmt = $this->conn->prepare($query);

         // Filter data
         $this->item_title = htmlspecialchars(strip_tags($this->item_title));
         $this->item_desc = htmlspecialchars(strip_tags($this->item_desc));
         $this->item_mere = htmlspecialchars(strip_tags($this->item_mere));
         $this->item_time = htmlspecialchars(strip_tags($this->item_time));
         $this->item_visibility = htmlspecialchars(strip_tags($this->item_visibility));
         $this->item_user = htmlspecialchars(strip_tags($this->item_user));
         $this->item_image = htmlspecialchars(strip_tags($this->item_image));
         $this->item_image1 = htmlspecialchars(strip_tags($this->item_image1));
         $this->item_image2 = htmlspecialchars(strip_tags($this->item_image2));
         $this->item_image3 = htmlspecialchars(strip_tags($this->item_image3));
         $this->image_desc = htmlspecialchars(strip_tags($this->image_desc));
         $this->image_desc1 = htmlspecialchars(strip_tags($this->image_desc1));
         $this->image_desc2 = htmlspecialchars(strip_tags($this->image_desc2));
         $this->image_desc3 = htmlspecialchars(strip_tags($this->image_desc3));
         $this->category_id = htmlspecialchars(strip_tags($this->category_id));
         $this->report_id = htmlspecialchars(strip_tags($this->report_id));
         $this->item_id = htmlspecialchars(strip_tags($this->item_id));

        // Bind data
        $stmt->bindParam(":item_title", $this->item_title);
        $stmt->bindParam(":item_desc", $this->item_desc);
        $stmt->bindParam(":item_mere", $this->item_mere);
        $stmt->bindParam(":item_time", $this->item_time);
        $stmt->bindParam(":item_visibility", $this->item_visibility);
        $stmt->bindParam(":item_user", $this->item_user);
        $stmt->bindParam(":item_image", $this->item_image);
        $stmt->bindParam(":item_image1", $this->item_image1);
        $stmt->bindParam(":item_image2", $this->item_image2);
        $stmt->bindParam(":item_image3", $this->item_image3);
        $stmt->bindParam(":image_desc", $this->image_desc);
        $stmt->bindParam(":image_desc1", $this->image_desc1);
        $stmt->bindParam(":image_desc2", $this->image_desc2);
        $stmt->bindParam(":image_desc3", $this->image_desc3);
        $stmt->bindParam(":category_id", $this->category_id);
        $stmt->bindParam(":report_id", $this->report_id);
        $stmt->bindParam(":item_id", $this->item_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE item_id = :item_id";
        $stmt = $this->conn->prepare($query);

        $this->item_id = htmlspecialchars(strip_tags($this->item_id));
        $stmt->bindParam(":item_id", $this->item_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}