<?php
class Inbox {
    // Database connection
    private $conn;
    private $table = "inbox";

    // Properties
    public $inbox_id;
    public $company_id;
    public $message1;
    public $created_at;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all 
    public function read() {
        $query = "SELECT
            inbox_id,
            company_id,
            message1,
            created_at
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            inbox_id,
            company_id,
            message1,
            created_at
        FROM 
            " . $this->table . "
        WHERE
            inbox_id = :inbox_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":inbox_id", $this->inbox_id); // Bind 1st ? inbox_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->inbox_id = $row["inbox_id"]; 
        $this->company_id = $row["company_id"]; 
        $this->message1 = $row["message1"]; 
        $this->created_at = $row["created_at"]; 
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            company_id = :company_id,
            message1 = :message1,
            created_at = CURRENT_TIMESTAMP
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));
        $this->message1 = htmlspecialchars(strip_tags($this->message1));

        // Bind data
        $stmt->bindParam(":company_id", $this->company_id);
        $stmt->bindParam(":message1", $this->message1);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            company_id = :company_id,
            message1 = :message1,
            created_at = CURRENT_TIMESTAMP
        WHERE
            inbox_id = :inbox_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));
        $this->message1 = htmlspecialchars(strip_tags($this->message1));
        $this->inbox_id = htmlspecialchars(strip_tags($this->inbox_id));

        // Bind data
        $stmt->bindParam(":company_id", $this->company_id);
        $stmt->bindParam(":message1", $this->message1);
        $stmt->bindParam(":inbox_id", $this->inbox_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE inbox_id = :inbox_id";
        $stmt = $this->conn->prepare($query);

        $this->inbox_id = htmlspecialchars(strip_tags($this->inbox_id));
        $stmt->bindParam(":inbox_id", $this->inbox_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}