<?php
class File {
    // Database connection
    private $conn;
    private $table = "files";

    // Properties
    public $file_id;
    public $file_name;
    public $company_id;
    public $location_id;
    public $user_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all 
    public function read() {
        $query = "SELECT
            file_id,
            file_name,
            company_id,
            location_id,
            user_id
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            file_id,
            file_name,
            company_id,
            location_id,
            user_id
        FROM 
            " . $this->table . "
        WHERE
        file_id = :file_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":file_id", $this->file_id); // Bind 1st ? to file_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->file_id = $row["file_id"]; 
        $this->file_name = $row["file_name"]; 
        $this->company_id = $row["company_id"]; 
        $this->location_id = $row["location_id"]; 
        $this->user_id = $row["user_id"]; 
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            file_name = :file_name,
            company_id = :company_id,
            location_id = :location_id,
            user_id = :user_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->file_name = htmlspecialchars(strip_tags($this->file_name));
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));
        $this->location_id = htmlspecialchars(strip_tags($this->location_id));
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));

        // Bind data
        $stmt->bindParam(":file_name", $this->file_name);
        $stmt->bindParam(":company_id", $this->company_id);
        $stmt->bindParam(":location_id", $this->location_id);
        $stmt->bindParam(":user_id", $this->user_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            file_name = :file_name,
            company_id = :company_id,
            location_id = :location_id,
            user_id = :user_id
        WHERE
            file_id = :file_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->file_name = htmlspecialchars(strip_tags($this->file_name));
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));
        $this->location_id = htmlspecialchars(strip_tags($this->location_id));
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $this->file_id = htmlspecialchars(strip_tags($this->file_id));

        // Bind data
        $stmt->bindParam(":file_name", $this->file_name);
        $stmt->bindParam(":company_id", $this->company_id);
        $stmt->bindParam(":location_id", $this->location_id);
        $stmt->bindParam(":user_id", $this->user_id);
        $stmt->bindParam(":file_id", $this->file_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE file_id = :file_id";
        $stmt = $this->conn->prepare($query);

        $this->file_id = htmlspecialchars(strip_tags($this->file_id));
        $stmt->bindParam(":file_id", $this->file_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}