<?php
class DriversLicence {
    // Database connection
    private $conn;
    private $table = "drivers_licence";

    // Properties
    public $drivers_licence_id;
    public $dl_title;
    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all
    public function read() {
        $query = "SELECT
            drivers_licence_id,
            dl_title
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            drivers_licence_id,
            dl_title
        FROM 
            " . $this->table . "
        WHERE
            drivers_licence_id = :drivers_licence_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":drivers_licence_id", $this->drivers_licence_id); 
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->drivers_licence_id = $row["drivers_licence_id"]; 
        $this->dl_title = $row["dl_title"]; 
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            dl_title = :dl_title
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->dl_title = htmlspecialchars(strip_tags($this->dl_title));

        // Bind data
        $stmt->bindParam(":dl_title", $this->dl_title);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            dl_title = :dl_title
        WHERE
            drivers_licence_id = :drivers_licence_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->dl_title = htmlspecialchars(strip_tags($this->dl_title));
        $this->drivers_licence_id = htmlspecialchars(strip_tags($this->drivers_licence_id));

        // Bind data
        $stmt->bindParam(":dl_title", $this->dl_title);
        $stmt->bindParam(":drivers_licence_id", $this->drivers_licence_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE drivers_licence_id = :drivers_licence_id";
        $stmt = $this->conn->prepare($query);

        $this->drivers_licence_id = htmlspecialchars(strip_tags($this->drivers_licence_id));
        $stmt->bindParam(":drivers_licence_id", $this->drivers_licence_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}