<?php
class CompanyAdmin {
    // Database connection
    private $conn;
    private $table = "company_admin";

    // Properties
    public $company_id;
    public $admin_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all 
    public function read() {
        $query = "SELECT
            company_id,
            admin_id
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function read_single($company_id, $admin_id) {
        $query = "SELECT
            company_id,
            admin_id
        FROM 
            " . $this->table . "
        WHERE
            company_id = :company_id
        AND
            admin_id = :admin_id
        ";
        $stmt = $this->conn->prepare($query);

        $stmt->bindParam(':company_id', $company_id);
        $stmt->bindParam(':admin_id', $admin_id);

        $stmt->execute();
        
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        // One row in API call
        $this->company_id = $row["company_id"];
        $this->admin_id = $row["admin_id"];
    }

    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            company_id = :company_id,
            admin_id = :admin_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));
        $this->admin_id = htmlspecialchars(strip_tags($this->admin_id));

        // Bind data
        $stmt->bindParam(":company_id", $this->company_id);
        $stmt->bindParam(":admin_id", $this->admin_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
            SET
                admin_id = :new_admin_id
            WHERE
                company_id = :company_id
            AND
                admin_id = :admin_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));
        $this->admin_id = htmlspecialchars(strip_tags($this->admin_id));
        $this->new_admin_id = htmlspecialchars(strip_tags($this->new_admin_id));

        // Bind data
        $stmt->bindParam(":company_id", $this->company_id);
        $stmt->bindParam(":admin_id", $this->admin_id);
        $stmt->bindParam(":new_admin_id", $this->new_admin_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . "
        WHERE
            company_id = :company_id
        AND
            admin_id = :admin_id
        ";

        $stmt = $this->conn->prepare($query);

        // Bind data
        $stmt->bindParam(":company_id", $this->company_id);
        $stmt->bindParam(":admin_id", $this->admin_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}