<?php
class Comment {
    // Database connection
    private $conn;
    private $table = "comments";

    // Properties
    public $comment_id;
    public $comment_text;
    public $comment_image;
    public $comment_user;
    public $comment_date;
    public $comment_time;
    public $item_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all comments
    public function read() {
        $query = "SELECT
            comment_id,
            comment_text,
            comment_image,
            comment_user,
            comment_date,
            comment_time,
            item_id
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get comment by id
    public function read_single() {
        $query = "SELECT
            comment_id,
            comment_text,
            comment_image,
            comment_user,
            comment_date,
            comment_time,
            item_id
        FROM 
            " . $this->table . "
        WHERE
        comment_id = :comment_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":comment_id", $this->comment_id); // Bind 1st ? to comment_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->comment_text = $row["comment_text"]; 
        $this->comment_image = $row["comment_image"]; 
        $this->comment_user = $row["comment_user"]; 
        $this->comment_date = $row["comment_date"]; 
        $this->comment_time = $row["comment_time"]; 
        $this->item_id = $row["item_id"]; 
    }
    
    // Create comment
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
        comment_text = :comment_text,
        comment_image = :comment_image,
        comment_user = :comment_user,
        comment_date = :comment_date,
        comment_time = :comment_time,
        item_id = :item_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->comment_text = htmlspecialchars(strip_tags($this->comment_text));
        $this->comment_image = htmlspecialchars(strip_tags($this->comment_image));
        $this->comment_user = htmlspecialchars(strip_tags($this->comment_user));
        $this->comment_date = htmlspecialchars(strip_tags($this->comment_date));
        $this->comment_time = htmlspecialchars(strip_tags($this->comment_time));
        $this->item_id = htmlspecialchars(strip_tags($this->item_id));

        // Bind data
        $stmt->bindParam(":comment_text", $this->comment_text);
        $stmt->bindParam(":comment_image", $this->comment_image);
        $stmt->bindParam(":comment_user", $this->comment_user);
        $stmt->bindParam(":comment_date", $this->comment_date);
        $stmt->bindParam(":comment_time", $this->comment_time);
        $stmt->bindParam(":item_id", $this->item_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update comment
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            comment_text = :comment_text,
            comment_image = :comment_image,
            comment_user = :comment_user,
            comment_date = :comment_date,
            comment_time = :comment_time,
            item_id = :item_id
        WHERE
            comment_id = :comment_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->comment_text = htmlspecialchars(strip_tags($this->comment_text));
        $this->comment_image = htmlspecialchars(strip_tags($this->comment_image));
        $this->comment_user = htmlspecialchars(strip_tags($this->comment_user));
        $this->comment_date = htmlspecialchars(strip_tags($this->comment_date));
        $this->comment_time = htmlspecialchars(strip_tags($this->comment_time));
        $this->item_id = htmlspecialchars(strip_tags($this->item_id));
        $this->comment_id = htmlspecialchars(strip_tags($this->comment_id));

        // Bind data
        $stmt->bindParam(":comment_text", $this->comment_text);
        $stmt->bindParam(":comment_image", $this->comment_image);
        $stmt->bindParam(":comment_user", $this->comment_user);
        $stmt->bindParam(":comment_date", $this->comment_date);
        $stmt->bindParam(":comment_time", $this->comment_time);
        $stmt->bindParam(":item_id", $this->item_id);
        $stmt->bindParam(":comment_id", $this->comment_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete comment
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE comment_id = :comment_id";
        $stmt = $this->conn->prepare($query);

        $this->comment_id = htmlspecialchars(strip_tags($this->comment_id));
        $stmt->bindParam(":comment_id", $this->comment_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}