<?php
class City {
    // Database connection
    private $conn;
    private $table = "cities";

    // Properties
    public $city_id;
    public $city_name;
    public $region_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all admins
    public function read() {
        $query = "SELECT
            city_id,
            city_name,
            region_id
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get admin by id
    public function read_single() {
        $query = "SELECT
            city_id,
            city_name,
            region_id
        FROM 
            " . $this->table . "
        WHERE
            city_id = :city_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":city_id", $this->city_id); // Bind 1st ? to city_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->city_name = $row["city_name"]; 
        $this->region_id = $row["region_id"]; 
    }
    
    // Create admin
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            city_name = :city_name,
            region_id = :region_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->city_name = htmlspecialchars(strip_tags($this->city_name));
        $this->region_id = htmlspecialchars(strip_tags($this->region_id));

        // Bind data
        $stmt->bindParam(":city_name", $this->city_name);
        $stmt->bindParam(":region_id", $this->region_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update admin
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            city_name = :city_name,
            region_id = :region_id
        WHERE
            city_id = :city_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->city_name = htmlspecialchars(strip_tags($this->city_name));
        $this->region_id = htmlspecialchars(strip_tags($this->region_id));
        $this->city_id = htmlspecialchars(strip_tags($this->city_id));

        // Bind data
        $stmt->bindParam(":city_name", $this->city_name);
        $stmt->bindParam(":region_id", $this->region_id);
        $stmt->bindParam(":city_id", $this->city_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete admin
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE city_id = :city_id";
        $stmt = $this->conn->prepare($query);

        $this->city_id = htmlspecialchars(strip_tags($this->city_id));
        $stmt->bindParam(":city_id", $this->city_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}