<?php
class ChatProfile
{
    // Database connection
    private $conn;
    private $table = "chat_profiles";

    // Properties
    public $profile_id;
    public $profile_name;
    public $user_id;
    public $location_id;
    public $company_id;

    // Constructor
    public function __construct($db)
    {
        $this->conn = $db;
    }

    // Get all profiles by user id
    public function read($user_id) {
        $query = "SELECT
            profile_id,
            profile_name,
            user_id,
            company_id
        FROM 
            " . $this->table . "
        WHERE 
            user_id = :user_id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":user_id", $user_id); // Bind 1st ? to address_book_id
        $stmt->execute();
        return $stmt;
    }
}