<?php
class AdminNote {
    // Database connection
    private $conn;
    private $table = "admin_notes";
    

    // Properties
    public $note_id;
    public $content;
    public $created_at;
    public $admin_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all notes
    public function read() {
        $query = "SELECT
            note_id,
            content,
            created_at,
            admin_id
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get note by id
    public function read_single() {
        $query = "SELECT
            note_id,
            content,
            created_at,
            admin_id
        FROM 
            " . $this->table . "
        WHERE
            note_id = :note_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":note_id", $this->note_id); // Bind 1st ? to note_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->content = $row["content"]; 
        $this->created_at = $row["created_at"]; 
        $this->admin_id = $row["admin_id"]; 
    }
    
    // Create admin note
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            content = :content,
            created_at = CURRENT_TIMESTAMP,
            admin_id = :admin_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->content = htmlspecialchars(strip_tags($this->content));
        $this->admin_id = htmlspecialchars(strip_tags($this->admin_id));

        // Bind data
        $stmt->bindParam(":content", $this->content);
        $stmt->bindParam(":admin_id", $this->admin_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update admin note
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            content = :content,
            created_at = CURRENT_TIMESTAMP,
            admin_id = :admin_id
        WHERE
            note_id = :note_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->content = htmlspecialchars(strip_tags($this->content));
        $this->admin_id = htmlspecialchars(strip_tags($this->admin_id));
        $this->note_id = htmlspecialchars(strip_tags($this->note_id));

        // Bind data
        $stmt->bindParam(":content", $this->content);
        $stmt->bindParam(":admin_id", $this->admin_id);
        $stmt->bindParam(":note_id", $this->note_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }

    
    // Delete admin note
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE note_id = :note_id";
        $stmt = $this->conn->prepare($query);

        $this->note_id = htmlspecialchars(strip_tags($this->note_id));
        $stmt->bindParam(":note_id", $this->note_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}