<?php
class AddressBook {
    // Database connection
    private $conn;
    private $table = "address_book";

    // Properties
    public $address_book_id;
    public $ab_name;
    public $ab_email;
    public $user_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all ab

//     SELECT * FROM `address_book` 
// INNER JOIN ((users INNER JOIN (user_company INNER JOIN companies ON user_company.company_id = companies.company_id) ON users.user_id = user_company.user_id) INNER JOIN admins ON users.user_id = admins.user_id) ON address_book.user_id = users.user_id
// WHERE companies.company_id = 1;
  public function read($company_id) {
        $query = "SELECT
            address_book_id,
            ab_name,
            ab_email
        FROM 
            " . $this->table . "
        WHERE 
            company_id = :company_id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":company_id", $company_id); // Bind 1st ? to address_book_id
        $stmt->execute();
        return $stmt;
    }

    public function readByAdminId($admin_id) {
        $query = "SELECT
            address_book_id,
            ab_name,
            ab_email
        FROM 
            " . $this->table . 
            " INNER JOIN ((users INNER JOIN (user_company INNER JOIN companies ON user_company.company_id = companies.company_id) ON users.user_id = user_company.user_id) INNER JOIN admins ON users.user_id = admins.user_id) ON address_book.user_id = users.user_id
        WHERE 
            admins.admin_id = :admin_id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":admin_id", $admin_id); // Bind 1st ? to address_book_id
        $stmt->execute();
        return $stmt;
    }
    // public function readUserByCompanyId($company_id) {
    //     $query = "SELECT
    //         users.user_id,
    //         user_fname,
    //         user_lname,
    //         user_email
    //     FROM 
    //         " . $this->table . 
    //         " INNER JOIN (user_company INNER JOIN companies 
    //           ON user_company.company_id = companies.company_id)  
    //           ON users.user_id = user_company.user_id 
    //     WHERE 
    //         companies.company_id = :company_id";
    //     $stmt = $this->conn->prepare($query);
    //     $stmt->bindParam(":company_id", $company_id); 
    //     $stmt->execute();
    //     return $stmt;
    // }
    
    // Get ab by id
    public function read_single() {
        $query = "SELECT
            address_book_id,
            ab_name,
            ab_email,
            user_id
        FROM 
            " . $this->table . "
        WHERE
            address_book_id = :address_book_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":address_book_id", $this->address_book_id); // Bind 1st ? to address_book_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->ab_name = $row["ab_name"]; 
        $this->ab_email = $row["ab_email"]; 
        $this->user_id = $row["user_id"]; 
    }
    
    // Create ab

    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            ab_name = :ab_name,
            ab_email = :ab_email,
            company_id = :company_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->ab_name = htmlspecialchars(strip_tags($this->ab_name));
        $this->ab_email = htmlspecialchars(strip_tags($this->ab_email));
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));

        // Bind data
        $stmt->bindParam(":ab_name", $this->ab_name);
        $stmt->bindParam(":ab_email", $this->ab_email);
        $stmt->bindParam(":company_id", $this->company_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    
    // Update ab
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            ab_name = :ab_name,
            ab_email = :ab_email
        WHERE
            address_book_id = :address_book_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->ab_name = htmlspecialchars(strip_tags($this->ab_name));
        $this->ab_email = htmlspecialchars(strip_tags($this->ab_email));
        $this->address_book_id = htmlspecialchars(strip_tags($this->address_book_id));

        // Bind data
        $stmt->bindParam(":ab_name", $this->ab_name);
        $stmt->bindParam(":ab_email", $this->ab_email);
        $stmt->bindParam(":address_book_id", $this->address_book_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete ab
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE address_book_id = :address_book_id";
        $stmt = $this->conn->prepare($query);

        $this->address_book_id = htmlspecialchars(strip_tags($this->address_book_id));
        $stmt->bindParam(":address_book_id", $this->address_book_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}