<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../models/User.php";
include_once "../../config/functions.php";


// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$user = new User($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$user->user_id = $data->user_id;
$user->user_fname = $data->user_fname;
$user->user_lname = $data->user_lname;
$user->user_email = $data->user_email;
$user->user_pin = $data->user_pin;

// Create a user
if (check_auth()) {
    if ($user->update()) {
        echo json_encode(
            array("message" => "User updated")
        );
    } else {
        echo json_encode(
            array("message" => "User not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update this user."
        )
    );
}