<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/User.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$user = new User($db);
$user->user_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$user->read_single();


// User array
$user_arr = array(
    "user_id" => $user->user_id,
    "user_fname" => $user->user_fname,
    "user_lname" => $user->user_lname,
    "user_email" => $user->user_email
);

if (check_auth()) {
    // Convert resutl to JSON
    print_r(json_encode($user_arr));
} else {
    echo json_encode(
        array("message" => "Not authorized to read this user.")
    );
}