<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
//include_once "../../config/authorization.php";
include_once "../../models/User.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Check if request method is POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get POST data
    $data = json_decode(file_get_contents("php://input"));

    // Check if email and PIN are provided
    if (!empty($data->user_email) && !empty($data->user_pin)) {
        // Initialize User object
        $user = new User($db);

        // Get user data by email
        $stmt = $user->getUserByEmail($data->user_email);
        $num = $stmt->rowCount();

        if ($num == 1) {
            // User found, fetch user details
            $user_data = $stmt->fetch(PDO::FETCH_ASSOC);

            // Verify PIN
            if ($user_data['user_pin'] == $data->user_pin) {
                // PIN matched, login successful
                http_response_code(200);
                echo json_encode(array("message" => "Login successful.", "user" => $user_data));
            } else {
                // Invalid PIN
                http_response_code(401);
                echo json_encode(array("message" => "Invalid PIN."));
            }
        } else {
            // User not found
            http_response_code(404);
            echo json_encode(array("message" => "User not found."));
        }
    } else {
        // Missing email or PIN
        http_response_code(400);
        echo json_encode(array("message" => "Both email and PIN are required."));
    }
} else {
    // Invalid request method
    http_response_code(405);
    echo json_encode(array("message" => "Method Not Allowed."));
}
?>
