<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, Access-Control-Allow-Origin');
header('Content-Type: application/json');

include_once "../../config/Database.php";
include_once "../../models/User.php";
include_once "../../config/functions.php";

$database = new Database();
$db = $database->connect();

$user = new User($db);

$user_email = isset($_GET['user_email']) ? $_GET['user_email'] : null;

$result = $user->getUserByEmail($user_email);
$num = $result->rowCount();

if (check_auth()) {
    if ($num > 0) {
        $user_arr = array();
        $user_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            $user_item = array(
                'user_id' => $user_id,
                'user_fname' => $user_fname,
                'user_lname' => $user_lname,
                'user_email' => $user_email
            );

            array_push($user_arr["data"], $user_item);
        }

        echo json_encode($user_arr);
    } else {
        echo json_encode(
            array(
                "message" => "No user found for the given email"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read this user"
        )
    );
}


?>
