<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../config/authorization.php";
include_once "../../models/User.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$user = new User($db);

// GET compay_id from URL 
$company_id = $_GET["company_id"];

// Store read method result in variable & count rows
$result = $user->getUserByCompanyId($company_id);
$num = $result->rowCount();

if (check_auth()) {
    if ($num > 0) {
        // User array
        $user_arr = array();
        $user_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each user will look like this
            $user = array(
                'user_id' => $user_id,
                'user_fname' => $user_fname,
                'user_lname' => $user_lname,
                'user_email' => $user_email,
                'user_tel_num' => $user_tel_num,
                'user_pin' => $user_pin,
                'profession_id' => $profession_id,
                'qualification_id' => $qualification_id, 
                'work_on_computer' => $work_on_computer,
                'area_id' => $area_id,
                'file_path' => $file_path,
                'user_location_privilege_id' => $user_location_privilege_id,
                'location_id' => $location_id,
                'privilege' => $privilege,
                'can_comment' => $can_comment,
                'num_img' => $num_img,
                'img_size' => $img_size,
                'num_char_obs' => $num_char_obs,
                'num_char_ta' => $num_char_ta,
                'location_name' => $location_name,
                'company_id' => $company_id

            );

            // Push to "Data"
            array_push($user_arr["data"], $user);
        }
        // Convert result to JSON
        echo json_encode($user_arr);
    } else {
        // No users returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No users found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read users"
        )
    );
}





