<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/UserNote.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init userNote object
$userNote = new UserNote($db);

// Store read method result in variable & count rows
$result = $userNote->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // userNote array
        $userNote_arr = array();
        $userNote_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each userNote will look like this
            $userNote = array(
                'note_id' => $note_id, 
                'content' => $content, 
                'created_at' => $created_at, 
                'user_id' => $user_id         
            );

            // Push to "Data"
            array_push($userNote_arr["data"], $userNote);
        }
        // Convert result to JSON
        echo json_encode($userNote_arr);
    } else {
        // No user notes returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No user notes found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read user notes."
        )
    );
}



