<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../models/UserNote.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user note object
$userNote = new UserNote($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$userNote->content = $data->content;
$userNote->user_id = $data->user_id;

if(check_auth()){
    // Create user note
    if ($userNote->create()) {
        echo json_encode(
            array("message" => "user note created")
        );
    } else {
        echo json_encode(
            array("message" => "user note not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create user note."
        )
    );
}