<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/UserLocationPrivilege.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init userLocPriv object
$userLocPriv = new UserLocationPrivilege($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$userLocPriv->user_location_privilege_id = $data->user_location_privilege_id;

if(check_auth()){
    // Create a userLocPriv
    if ($userLocPriv->delete()) {
        echo json_encode(
            array("message" => "userLocPriv deleted")
        );
    } else {
        echo json_encode(
            array("message" => "userLocPriv not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete user location privilege."
        )
    );
}
