<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/UserLanguage.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$userLanguage = new UserLanguage($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$userLanguage->user_location_id = $data->user_location_id;
$userLanguage->language_id = $data->language_id;
$userLanguage->user_id = $data->user_id;

if(check_auth()){
    if ($userLanguage->update()) {
        echo json_encode(array("message" => "user language updated"));
    } else {
        echo json_encode(array("message" => "user language not updated"));
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update user language."
        )
    );
}
