<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/UserDriversLicence.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user_dl object
$user_dl = new UserDriversLicence($db);

// Store read method result in variable & count rows
$result = $user_dl->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // user_dl array
        $user_dl_arr = array();
        $user_dl_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each user_dl will look like this
            $user_dl = array(
                'us_drivers_licence_id' => $us_drivers_licence_id, 
                'user_id' => $user_id,
                'drivers_licence_id' => $drivers_licence_id     
            );

            // Push to "Data"
            array_push($user_dl_arr["data"], $user_dl);
        }
        // Convert result to JSON
        echo json_encode($user_dl_arr);
    } else {
        // No drivers licence returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No drivers licence found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read drivers licences."
        )
    );
}




