<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/UserCompany.php";
//include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init userCompany object
$userCompany = new UserCompany($db);

$company_id =  isset($_GET["company_id"]) ? $_GET["company_id"] : die();
// Store read method result in variable & count rows
$result = $userCompany->readByCompanyId($company_id);
$num = $result->rowCount();

if(!check_auth()){
    if ($num > 0) {
        // userCompany array
        $userCompany_arr = array();
        $userCompany_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each userCompany will look like this
            $userCompany = array(
         
                'company_name' => $company_name,
                'user_fname' => $user_fname,
                'user_lname' => $user_lname,
                'user_email' => $user_email,
                'entry_key' => $entry_key    
            );

            // Push to "Data"
            array_push($userCompany_arr["data"], $userCompany);
        }
        // Convert result to JSON
        echo json_encode($userCompany_arr);
    } else {
        // No company places returned from query
        header("HTTP/1.1 404");
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No company places found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read company places."
        )
    );
}




