<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/UserCompany.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init ab object
$userCompany = new UserCompany($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$userCompany->user_company_id = $data->user_company_id;

if(check_auth()){
    // Create
    if ($userCompany->delete()) {
        echo json_encode(
            array("message" => "user company deleted")
        );
    } else {
        echo json_encode(
            array("message" => "user company not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete user."
        )
    );
}