<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/UserCompany.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init object
$userCompany = new UserCompany($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$userCompany->user_id = $data->user_id;
$userCompany->company_id = $data->company_id;
$userCompany->entry_key = $data->entry_key;

if(check_auth()){
    // Create
    if ($userCompany->create()) {
        echo json_encode(
            array("message" => "user company created")
        );
    } else {
        echo json_encode(
            array("message" => "user company not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create user."
        )
    );
}