<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Room.php";
//include_once "../../config/authorization.php";
include_once "../../config/functions.php";
include_once "../../helpers/chat_name_helper.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init address book object
$room = new Room($db);

// GET profile_id from URL 
$id =  isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable & count rows
$result = $room->read($id);
$num = $result->rowCount();


if(!check_auth()){
    if ($num > 0) {
        // address book array
        $room_arr = array();
        $room_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Check which user i am chatting with
            if ($id == $room_profile1) {
                $chat_name = getProfileNameByRoomProfileId($conn, $room_profile2);
            } else {
                $chat_name = getProfileNameByRoomProfileId($conn, $room_profile1);
            }

            // Each address book will look like this
            $room = array(
                'id' => $room_id,
                'chat' => $chat_name,
            );

            // Push to "Data"
            array_push($room_arr["data"], $room);
        }
        // Convert result to JSON
        echo json_encode($room_arr);
    } else {
        // No address book returned from query
         header("HTTP/1.1 404");
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No profiles found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read profiles."
        )
    );
}




