<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/RegulationRegCategory.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init regCategory object
$regulationRegCategory = new RegulationRegCategory($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$regulationRegCategory->reg_category_id = $data->reg_category_id;
$regulationRegCategory->regulation_id = $data->regulation_id;
$regulationRegCategory->regulations_reg_categories_id = $data->regulations_reg_categories_id;

if(check_auth()){
    // Create regulationRegCategory
    if ($regulationRegCategory->update()) {
        echo json_encode(
            array("message" => "regulationRegCategory updated")
        );
    } else {
        echo json_encode(
            array("message" => "regulationRegCategory not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update regulations reg category."
        )
    );
}