<?php 
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/RegulationRegCategory.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$regulationRegCategory = new RegulationRegCategory($db);

// Store read method result in variable & count rows
$result = $regulationRegCategory->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // User array
        $regulationRegCategory_arr = array();
        $regulationRegCategory_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each user will look like this
            $regulationRegCategory = array(
                'regulations_reg_categories_id' => $regulations_reg_categories_id,
                'regulation_id' => $regulation_id,
                'reg_category_id' => $reg_category_id
            );

            // Push to "Data"
            array_push($regulationRegCategory_arr["data"], $regulationRegCategory);
        }
        // Convert result to JSON
        echo json_encode($regulationRegCategory_arr);
    } else {
        // No users returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No regulationRegCategory found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read regulations reg categories."
        )
    );
}




