<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Regulation.php";
include_once "../../config/authorization.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init regulation object
$regulation = new Regulation($db);

// Store read method result in variable & count rows
$result = $regulation->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // regulation array
        $regulation_arr = array();
        $regulation_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each regulation will look like this
            $regulation = array(
                'regulation_id' => $regulation_id,
                'title' => $title,
                'created_at' => $created_at,
                'version1' => $version1,   
                'version2' => $version2,
                'version3' => $version3,
                'reg_category_id' => $reg_category_id      
            );

            // Push to "Data"
            array_push($regulation_arr["data"], $regulation);
        }
        // Convert result to JSON
        echo json_encode($regulation_arr);
    } else {
        // No regulation returned from query
        echo json_encode(
            array(
                "version3" => 404,
                "message" => "No regulation found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read regulations."
        )
    );
}





