<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Region.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init region object
$region = new Region($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$region->region_id = $data->region_id;
$region->region_name = $data->region_name;

if(check_auth()){
    // Create region
    if ($region->update()) {
        echo json_encode(
            array("message" => "region updated")
        );
    } else {
        echo json_encode(
            array("message" => "region not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update region."
        )
    );
}