<?php 
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Region.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$region = new Region($db);

// Store read method result in variable & count rows
$result = $region->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // User array
        $region_arr = array();
        $region_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each user will look like this
            $region = array(
                'region_id' => $region_id,
                'region_name' => $region_name
            );

            // Push to "Data"
            array_push($region_arr["data"], $region);
        }
        // Convert result to JSON
        echo json_encode($region_arr);
    } else {
        // No users returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No regions found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read regions."
        )
    );
}




