<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/RegCategory.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init regCategory object
$regCategory = new RegCategory($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$regCategory->reg_category_id = $data->reg_category_id;
$regCategory->reg_category_name = $data->reg_category_name;

if(check_auth()){
    // Create regCategory
    if ($regCategory->update()) {
        echo json_encode(
            array("message" => "regCategory updated")
        );
    } else {
        echo json_encode(
            array("message" => "regCategory not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update regulation category."
        )
    );
}