<?php 
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/RegCategory.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$regCategory = new RegCategory($db);

// Store read method result in variable & count rows
$result = $regCategory->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // User array
        $regCategory_arr = array();
        $regCategory_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each user will look like this
            $regCategory = array(
                'reg_category_id' => $reg_category_id,
                'reg_category_name' => $reg_category_name
            );

            // Push to "Data"
            array_push($regCategory_arr["data"], $regCategory);
        }
        // Convert result to JSON
        echo json_encode($regCategory_arr);
    } else {
        // No users returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No regCategorys found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read regulation categories."
        )
    );
}




