<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Qualification.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$qualification = new Qualification($db);
$qualification->qualification_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$qualification->read_single();

// qualification array
$qualification_arr = array(
    "qualification_id" => $qualification->qualification_id,
    "qual_name" => $qualification->qual_name
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($qualification_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read qualification."
        )
    );
}