<?php 
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Qualification.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$qualification = new Qualification($db);

// Store read method result in variable & count rows
$result = $qualification->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // User array
        $qualification_arr = array();
        $qualification_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each user will look like this
            $qualification = array(
                'qualification_id' => $qualification_id,
                'qual_name' => $qual_name
            );

            // Push to "Data"
            array_push($qualification_arr["data"], $qualification);
        }
        // Convert result to JSON
        echo json_encode($qualification_arr);
    } else {
        // No users returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No qualifications found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read qualifications."
        )
    );
}




