<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Provider.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init provider object
$provider = new Provider($db);
$provider->provider_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$provider->read_single();

// provider array
$provider_arr = array(
    "provider_id" => $provider->provider_id,
    "provider_title" => $provider->provider_title,
    "city_id" => $provider->city_id,
    "provider_inum" => $provider->provider_inum,
    "provider_phone" => $provider->provider_phone,
    "provider_email" => $provider->provider_email,
    "pc_id" => $provider->pc_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($provider_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read provider."
        )
    );
}