<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Provider.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init provider object
$providerObj = new Provider($db);
$provider_id = $_GET['provider_id'];

// Store read method result in variable 
$result = $providerObj->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // provider array
        $providerArr = array();
        $providerArr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            $providerData = array(
                'provider_id' => $provider_id,
                'provider_title' => $provider_title,
                'city_id' => $city_id,
                'provider_inum' => $provider_inum,
                'provider_phone' => $provider_phone,
                'provider_email' => $provider_email,
                'provider_licences' => array()
            );
    
            $providerLicences = $providerObj->readLicencesByProviderId($provider_id);

            foreach ($providerLicences as $licence) {
                $licenceData = array(
                    'pl_number' => $licence['pl_number'],
                    'pl_date' => $licence['pl_date']
                );
                $providerData['provider_licences'][] = $licenceData;
            }

            $providerArr["data"][] = $providerData;
        }
        // Convert result to JSON
        echo json_encode($providerArr);
    } else {
        // No providers returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No providers found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read licences by provider id."
        )
    );
}
?>
