<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/ProviderLicence.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init providerLicence object
$providerLicence = new ProviderLicence($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$providerLicence->pl_id = $data->pl_id;
$providerLicence->pl_number = $data->pl_number;
$providerLicence->pl_date = $data->pl_date;
$providerLicence->provider_id = $data->provider_id;

if(check_auth()){
    // Create providerLicence
    if ($providerLicence->update()) {
        echo json_encode(
            array("message" => "provider licence updated")
        );
    } else {
        echo json_encode(
            array("message" => "provider licence not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update provider licence."
        )
    );
}