<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/ProviderCategory.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$providerCategory = new ProviderCategory($db);
$providerCategory->pc_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$providerCategory->read_single();

// providerCategory array
$providerCategory_arr = array(
    "pc_id" => $providerCategory->pc_id,
    "pc_name" => $providerCategory->pc_name
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($providerCategory_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read provider category."
        )
    );
}