<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/ProviderCategory.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init providerCategory object
$providerCategory = new ProviderCategory($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$providerCategory->pc_id = $data->pc_id;

if(check_auth()){
    // Create a providerCategory
    if ($providerCategory->delete()) {
        echo json_encode(
            array("message" => "Provider Category deleted")
        );
    } else {
        echo json_encode(
            array("message" => "Provider Category not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete provider category."
        )
    );
}