<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Profession.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init profession object
$profession = new Profession($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$profession->prof_name = $data->prof_name;

if(check_auth()){
    // Create profession
    if ($profession->create()) {
        echo json_encode(
            array("message" => "profession created")
        );
    } else {
        echo json_encode(
            array("message" => "profession not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create profession."
        )
    );
}